combinedtable <- read.table("table.txt", header=TRUE,as.is=TRUE)

genes <- names(table(combinedtable$ID))
#print(length(genes))

print("All genes");
subsetoftable=subset(combinedtable, ID != '-')
paired <- as.numeric(subset(subsetoftable, Paired == "yes")$dS_Values)
unpaired <- as.numeric(subset(subsetoftable, Paired == "no")$dS_Values)
print("---Testing for when the paired median is lower than the unpaired median---")
print("Median paired:")
print(median(paired))
print("Median unpaired:")
print(median(unpaired))
MWUtest <- wilcox.test(paired, unpaired,alternative = c("less"))
print("p value:")
print(MWUtest$p.value)
# print("---Testing for when the paired (geometric) mean is lower than the unpaired (geometric) mean---")
# print("(Geometric) Mean paired:")
# print(exp(mean(log(paired))))
# print("(Geometric) Mean unpaired:")
# print(exp(mean(log(unpaired))))
# ttest <- t.test(log(paired), log(unpaired),alternative = c("less"))
# print("p value:")
# print(ttest$p.value)
print("---Testing for any difference in distribution---")
kstest <- ks.test(paired, unpaired)
print("p value:")
print(kstest$p.value)
print("---Is the result the wrong way around (is the paired median greater than the unparied median)?---")
MWUtestWrong <- wilcox.test(paired, unpaired,alternative = c("greater"))
print("p value:")
print(MWUtestWrong[3]$p.value)